#define checkBox    0
#define radio       1
#define simple      2
#define iconbtn     3
#define listctl     4
#define menuctl     5
#define scroll      6
#define sizebox     7
#define textedit    8
#define thermo      9

/* Color Assumptions...

Col #       640 Color       320 Color
    0       Black           Black
    1       Navy Blue       Dark Gray
    2       Khaki           Maroon
    3       Gray 1          Dk Blue
    4       Red             Blue
    5       Purple          Green
    6       Orange          Red
    7       Pink            Dk Red
    8       Green           Orange
    9       Forest Green    Yellow
    A       Lt Green 1      Lt Green
    B       Lt Green 2      Aqua
    C       Gray 2          Puce
    D       Periwinkle Blue Blue 2
    E       Yellow          Lt Gray
    F       White           White
    */

/* These are the rects to be used by the various control color editors...

CheckBox, Radio Button (BoxColors)
            Foreground              Background
Normal  -   1  [0] Nor:3-0          2  [1] Nor:7-4
Selected-   3  [3] Sel:3-0          4  [4] Sel:7-4
Title-      4  [2] Title:3-0        6  [5] Title:7-4

SimpleButton, Icon Button  (ButtonColors)
            Foreground              Background
Normal  -   1  [0] Outline:7-4      2  [1] NorBack:7-4  & NorText:7-4
Selected-                           4  [4] SelBack:7-4  & SelText:7-4
NorText-    5  [2] NorText:3-0
SelText-    7  [3] SelText:3-0

List Control (ListColors)
            Foreground              Background
Frame       1  [0] Frame:3-0
NorText     3  [2] NorText:3-0      4  [1] NorBack:3-0
SelText     5  [3] SelText:3-0      6  [4] SelBack:3-0


PopUpMenu (MenuColors)
            Foreground              Background
Outline     1  [0] Outline:3-0
NorText     3  [2] NorText:3-0      4  [1] NorText:7-4
HiText      5  [3] HiText:3-0       6  [4] HiText:7-4

Scroll Bar (ScrollColors)
            Foreground              Background
ScrollBar   1  [0] Outline:7-4      2  [1] ArrowBack:7-4 & Inactive:7-4
NorArrow    3  [2] NorArrow:3-0     4  [5] NorArrow:7-4 & NorThumb:7-4
SelArrow    5  [3] SelArrow:3-0     6  [4] SelArrow:7-4
PageRgn     7  [6] PageRgn:3-0      8  [7] PageRgn:7-4
    NOTE- if 7 & 8 are different, set PageRgn b8

SizeBox (SizeColors) [3]
            Foreground              Background
Outline     1  [0] Outline:7-4
Rectangle   3  [2] NorBack:3-0      4  [1] NorBack:7-4

TextEdit (TEColors) [4]
            Foreground              Background
Rectangle   1  [0] Outline:3-0      2  [1] Content:3-0
  The rest is dispatched to scrollbar & sizebox editors

ThemoBar (ThermColors) [3]
            Foreground              Background
Control     1  [0] Outline:3-0      2  [1] Interior:3-0
Thermometer 3  [3] ForeGnd:3-0      4  [4] BackGnd:3-0
    NOTE- if 3 & 4 are different, set BackGnd b15
*/

struct PrivDataClr {
    long        parentKind;
    word        shortKind;
    long        parentID;
    handle      originalData;
    word        MasterColor[8];   /* See definition below */
};
typedef struct PrivDataClr PrivDataClr, *PrivDataClrPtr, **PrivDataClrHndl;

struct BoxColors {
   Word Reserved;   /* reserved */
   Word Nor;        /* color of box when not checked */
   Word Sel;        /* color of box when checked */
   Word Title;      /* color of check box's title */
} ;
typedef struct BoxColors BoxColors, *BoxColorsPtr, **BoxColorsHndl;

struct ButtonColors {
   Word Outline; /* color of outline */
   Word NorBack;    /* color of background when not selected */
   Word SelBack;    /* color of background when selected */
   Word NorText;    /* color of title's text when not selected */
   Word SelText;    /* color of title's text when selected */
} ;
typedef struct ButtonColors ButtonColors, *ButtonColorsPtr, **ButtonColorsHndl;

struct ListColors {
   Word Frame;      /* Frame color */
   Word NorText;    /* Unhighlighted text color */
   Word SelText;    /* Highlighted text color */
   Word NorBack;    /* Unhighlighted background color */
   Word SelBack;    /* Highlighted backgraound color */
} ;
typedef struct ListColors ListColors, *ListColorsPtr, **ListColorsHndl;

struct MenuColors {
    Word NorText;   /* Normal text color /*
    Word HiText;    /* Hilited text color */
    Word Outline;   /* Outline color */
} ;
typedef struct MenuColors MenuColors, *MenuColorsPtr, **MenuColorsHndl;

struct ScrollColors {
   Word Outline; /* color for outlining bar, arrows, and thumb */
   Word NorArrow; /* color of arrows when not highlighted */
   Word SelArrow; /* color of arrows when highlighted */
   Word ArrowBack; /* color of arrow box's background */
   Word NorThumb; /* color of thumb's background when not highlighted */
   Word SelThumb; /* color of thumb's background when highlighted */
   Word PageRgn; /* color and pattern page region: high byte - 1= dither, 0 = solid */
   Word Inactive; /* color of scroll bar's interior when inactive */
} ;
typedef struct ScrollColors ScrollColors, *ScrollColorsPtr, **ScrollColorsHndl;

struct SizeColors {
   Word Outline;    /* color of outline */
   Word NorBack;    /* color of background when not selected */
} ;
typedef struct SizeColors SizeColors, *SizeColorsPtr, **SizeColorsHndl;

struct TEColors {
   Word content;    /* color of background */
   Word outline;    /* color of outline */
   Word hiliteFore; /* RESERVED */
   Word hiliteBack; /* RESERVED */
   Word vertDescriptor;  /* Vert Scroll Descriptor- may have kiddies! */
   Long vertRef;         /* REF from above */
   Word horzDescriptor;  /* Horz Scroll Descriptor- may have kiddies! */
   Long horzRef;         /* REF from above */
   Word growDescriptor;  /* Grow Box Descriptor- may have kiddies! */
   Long growRef;         /* REF from above */
} ;
typedef struct TEColors TEColors, *TEColorsPtr, **TEColorsHndl;

struct ThermColors {
    Word Outline;   /* Outline color bit 0-4 */
    Word Interior;  /* Interior color bit 0-4 */
    Word Foregnd;   /* Foreground color bit 0-4 */
    Word Backgnd;   /* Background color bit 0-4, bit 15 if dotted pattern */
} ;
typedef struct ThermColors ThermColors, *ThermColorsPtr, **ThermColorsHndl;

union ctlClr {
    Pointer                 dummy;
    BoxColorsPtr            *BoCol;  /* Check Box, Radio Button */
    ButtonColorsPtr         *BuCol;  /* Simple Button, Icon Button */
    ListColorsPtr           *LiCol;  /* List Control */
    MenuColorsPtr           *MeCol;  /* PopUpMenu */
    ScrollColorsPtr         *ScCol;  /* ScrollBar */
    SizeColorsPtr           *SiCol;  /* Size Box */
    TEColorsPtr             *TECol;  /* Text Edit */
    ThermColorsPtr          *ThCol;  /* ThermoBar */
};
typedef union ctlClr ctlClr;

struct servant {
    word    numColors;
    word    cRect[8];
    word    color[8];
};
typedef struct servant servant;

/* LineEdit, Picture, StatText, Rectangle do not utilize Color Templates */

Rect    ColorRect[9] = {    {11, 168, 23, 198},     /* 0 */
                            {16, 180, 28, 210},     /* 1 */
                            {32, 168, 44, 198},     /* 2 */
                            {37, 180, 49, 210},     /* 3 */
                            {53, 168, 65, 198},     /* 4 */
                            {58, 180, 70, 210},     /* 5 */
                            {74, 168, 86, 198},     /* 6 */
                            {79, 180, 91, 210} };   /* 7 */


/*	{62, 128, 72, 152},      These are possible locations for the
	{73, 128, 83, 152},      rects for the WINDOW color table editor
	{84, 128, 94, 152},
	{95, 128, 105, 152},
	{106, 128, 116, 152},
	{62, 272, 72, 296},    */






word    MasterColor[8];     /* this is used to store our transient color
                               values- especially useful for translation-
                               Translation table:
                               [0] - Outline
                               [1] - Normal Background
                               [2] - Normal Text Foreground
                               [3] - Selected Foreground
                               [4] - Selected Background
                               [5] - Normal Text Background, outside of [1]
                               [6] - Pattern Foreground
                               [7] - Pattern Background
                               */

servant Slave[10] = {6, {5,4,3,2,1,0,0,0}, {5,2,4,3,1,0,0,0}}, /* CheckBox */
                    {6, {5,4,3,2,1,0,0,0}, {5,2,4,3,1,0,0,0}}, /* Radio Btn */
                    {5, {5,4,3,1,0,0,0,0}, {3,2,4,1,0,0,0,0}}, /* Simple Btn */
                    {5, {5,4,3,1,0,0,0,0}, {3,2,4,1,0,0,0,0}}, /* Icon Button */
                    {5, {5,4,3,2,0,0,0,0}, {4,3,1,2,0,0,0,0}}, /* List */
                    {5, {5,4,3,2,0,0,0,0}, {4,3,1,2,0,0,0,0}}, /* PopUp /*
                    {8, {7,6,5,4,3,2,1,0}, {7,6,4,3,5,2,1,0}}, /* Scroll Bar */
                    {3, {3,2,0,0,0,0,0,0}, {1,3,4,0,0,0,0,0}}, /* Size Box */
                    {2, {1,0,0,0,0,0,0,0}, {1,0,0,0,0,0,0,0}}, /* TextEdit */
                    {4, {3,2,1,0,0,0,0,0}, {4,3,1,0,0,0,0,0}}};/* Thermometer */

PrivDataClrHndl     MasterCHndl;
fColorRec           p;



/*--------------------------------------
    GetMasterColors extracts the current settings for a control color table
    and places them for manipulation into our master color array.  It also
    stores a copy in the private data for the particular control editor window
    for use later.  Notice that we are somewhat forcing the users hand to make
    sure such tacky details like Text Background and Item Background are
    not in conflict with each other.  Bye Bye, DesignBlaster!!!

    Mark T. Collins    3/6/92  3:44PM
*/

void GetMasterColors(long ctlType)
{
ctlCol  theColors;
PrivDataPtr mPtr;
/* LineEdit, Picture, StatText, Rectangle do not utilize Color Templates */

    (Pointer) mPtr = deref((Handle) MasterCHndl);
    theColors = mPtr->originalData;

    switch (ctlType) {
        case checkControl:
        case radioControl: {
            mPtr->MasterColor[0] =  BoCol.Nor & 0x000f;
            mPtr->MasterColor[1] =  BoCol.Nor & 0x00f0 >> 4;
            mPtr->MasterColor[2] =  BoCol.Title & 0x000f;
            mPtr->MasterColor[3] =  BoCol.Sel & 0x000f;
            mPtr->MasterColor[4] =  BoCol.Sel & 0x00f0 >> 4;
            mPtr->MasterColor[5] =  BoCol.Title & 0x00f0 >> 4;
            mPtr->MasterColor[6] =  BoCol.Title & 0x000f;
            mPtr->MasterColor[7] =  BoCol.Nor & 0x00f0 >>4;
            break;
        }
        case simpleButtonControl: {
        case iconButtonControl:
        case 0x07ff0001:
            mPtr->MasterColor[0] =  BuCol.Outline & 0x00f0 >> 4;
            mPtr->MasterColor[1] =  BuCol.NorBack & 0x00f0 >> 4;
            mPtr->MasterColor[2] =  BuCol.NorText & 0x000f;
            mPtr->MasterColor[3] =  BuCol.SelText & 0x000f;
            mPtr->MasterColor[4] =  BuCol.SelBack & 0x00f0 >> 4;
            mPtr->MasterColor[5] =  BuCol.SelBack & 0x00f0 >> 4;
            mPtr->MasterColor[6] =  BuCol.NorText & 0x000f;
            mPtr->MasterColor[7] =  BuCol.NorBack & 0x00f0 >> 4;
            break;
        }
        case listControl:
            mPtr->MasterColor[0] =  LiCol.Frame & 0x000f;
            mPtr->MasterColor[1] =  LiCol.NorBack & 0x000f;
            mPtr->MasterColor[2] =  LiCol.NorText & 0x000f;
            mPtr->MasterColor[3] =  LiCol.SelText & 0x000f;
            mPtr->MasterColor[4] =  LiCol.SelBack & 0x000f;
            mPtr->MasterColor[5] =  LiCol.NorBack & 0x000f;
            mPtr->MasterColor[6] =  LiCol.NorText & 0x000f;
            mPtr->MasterColor[7] =  LiCol.NorBack & 0x000f;
            break;
        }
        case popUpControl: {
            mPtr->MasterColor[0] =  MeCol.Outline & 0x000f;
            mPtr->MasterColor[1] =  MeCol.NorText & 0x00f0 >> 4;
            mPtr->MasterColor[2] =  MeCol.NorText & 0x000f;
            mPtr->MasterColor[3] =  MeCol.HiText & 0x000f;
            mPtr->MasterColor[4] =  MeCol.HiText & 0x00f0 >> 4;
            mPtr->MasterColor[5] =  MeCol.NorText & 0x00f0 >> 4;
            mPtr->MasterColor[6] =  MeCol.NorText & 0x000f;
            mPtr->MasterColor[7] =  MeCol.NorText & 0x00f0 >> 4;
            break;
        }
        case scrollBarControl: {
            mPtr->MasterColor[0] =  ScCol.Outline & 0x00f0 >> 4;
            mPtr->MasterColor[1] =  ScCol.ArrowBack & 0x00f0 >> 4;
            mPtr->MasterColor[2] =  ScCol.NorArrow & 0x000f;
            mPtr->MasterColor[3] =  ScCol.SelArrow & 0x000f;
            mPtr->MasterColor[4] =  ScCol.SelArrow & 0x00f0 >> 4;
            mPtr->MasterColor[5] =  ScCol.NorArrow & 0x00f0 >> 4;
            mPtr->MasterColor[6] =  ScCol.PageRgn & 0x000f;
            mPtr->MasterColor[7] =  ScCol.PageRgn & 0x00f0 >> 4;
            break;
        }
        case growControl:
            mPtr->MasterColor[0] =  SiCol.Outline & 0x00f0 >> 4;
            mPtr->MasterColor[1] =  SiCol.NorBack & 0x00f0 >> 4;
            mPtr->MasterColor[2] =  SiCol.NorBack & 0x000f;
            mPtr->MasterColor[3] =  SiCol.NorBack & 0x000f;
            mPtr->MasterColor[4] =  SiCol.NorBack & 0x00f0 >> 4;
            mPtr->MasterColor[5] =  SiCol.NorBack & 0x00f0 >> 4;
            mPtr->MasterColor[6] =  SiCol.NorBack & 0x000f;
            mPtr->MasterColor[7] =  SiCol.NorBack & 0x00f0 >> 4;
            break;
        }
        case editTextControl: {
            mPtr->MasterColor[0] =  TECol.Outline & 0x000f;
            mPtr->MasterColor[1] =  TECol.Content & 0x000f;
            mPtr->MasterColor[2] =  TECol.Outline & 0x000f;
            mPtr->MasterColor[3] =  TECol.Content & 0x000f;
            mPtr->MasterColor[4] =  TECol.Outline & 0x000f;
            mPtr->MasterColor[5] =  TECol.Outline & 0x000f;
            mPtr->MasterColor[6] =  TECol.Outline & 0x000f;
            mPtr->MasterColor[7] =  TECol.Content & 0x000f;
            break;
        }
        case thermometerControl: {
            mPtr->MasterColor[0] =  ThCol.Outline & 0x000f;
            mPtr->MasterColor[1] =  ThCol.Content & 0x000f;
            mPtr->MasterColor[2] =  ThCol.Outline & 0x000f;
            mPtr->MasterColor[3] =  ThCol.Content & 0x000f;
            mPtr->MasterColor[4] =  ThCol.Outline & 0x000f;
            mPtr->MasterColor[5] =  ThCol.Outline & 0x000f;
            mPtr->MasterColor[6] =  ThCol.Outline & 0x000f;
            mPtr->MasterColor[7] =  ThCol.Content & 0x000f;
            break;
        }
    }
}

/*--------------------------------------
    SetMasterColors replaces the current settings for a control color table
    from our master color array.

    Mark T. Collins    3/8/92 10:24AM
*/

void SetMasterColors(long ctlType)
{
ctlCol          theColors;
PrivDataPtr     mPtr;
/* LineEdit, Picture, StatText, Rectangle do not utilize Color Templates */

    (Pointer) mPtr = deref((Handle) MasterCHndl);
    theColors = mPtr->originalData;

    switch (ctlType) {
        case checkControl:
        case radioControl: {
            BoCol.Reserved = 0;
            BoCol.Nor = MasterColor[0] & (MasterColor[1] << 4);
            BoCol.Sel = MasterColor[3] & (MasterColor[4] << 4);
            BoCol.Title = MasterColor[2] & (MasterColor[5] << 4);
            break;
        }
        case simpleButtonControl:
        case iconButtonControl:
        case 0x07ff0001: {
            BuCol.Outline  = mPtr->MasterColor[0] << 4;
            BuCol.NorBack  = mPtr->MasterColor[2] << 4;
            BuCol.SelBack  = mPtr->MasterColor[4] << 4;
            BuCol.NorText  = mPtr->MasterColor[2] & (mPtr->MasterColor[1] << 4);
            BuCol.SelText  = mPtr->MasterColor[3] & (mPtr->MasterColor[4] << 4);
            break;
        }
        case listControl:
            LiCol.Frame = mPtr->MasterColor[0];
            LiCol.NorText = mPtr->MasterColor[2];
            LiCol.SelText = mPtr->MasterColor[3];
            LiCol.NorBack = mPtr->MasterColor[1];
            LiCol.SelBack = mPtr->MasterColor[4];
            break;
        }
        case popUpControl:
            MeCol.NorText = mPtr->MasterColor[2] & (mPtr->MasterColor[1] << 4);
            MeCol.HiText = mPtr->MasterColor[3] & (mPtr->MasterColor[4] << 4);
            MeCol.Outline = mPtr->MasterColor[0];
            break;
        }
        case scrollBarControl: {
            ScCol.Outline = mPtr->MasterColor[0] << 4;
            ScCol.NorArrow = mPtr->MasterColor[2] & (mPtr->MasterColor[5] << 4);
            ScCol.SelArrow = mPtr->MasterColor[3] & (mPtr->MasterColor[4] << 4);
            ScCol.ArrowBack = mPtr->MasterColor[1] << 4;
            ScCol.NorThumb = mPtr->MasterColor[5] << 4;
            ScCol.SelThumb = 0;
            ScCol.PageRgn = mPtr->MasterColor[6] & mPtr->MasterColor[7] << 4;
            ScCol.Inactive = mPtr->MasterColor[1] << 4;
            if (MasterColor[6] != MasterColor[7])
                ScCol.PageReg &= 0x8000;
            break;
        }
        case growControl:
            SiCol.Outline = mPtr->MasterColor[0] << 4;
            SiCol.NorBack = mPtr->MasterColor[2] & (mPtr->MasterColor[1] << 4);
            break;
        }
        case editTextControl: {
            TECol.Content = mPtr->MasterColor[1];
            TECol.Outline = mPtr->MasterColor[0];
            break;
        }
        case thermometerControl: {
            TECol.Outline = mPtr->MasterColor[0];
            TECol.Interior = mPtr->MasterColor[1];
            TECol.Foregnd = mPtr->MasterColor[3];
            TECol.Backgnd = mPtr->MasterColor[4];
            if TECol.Foregnd != TECol.Backgnd
                TECol.Backgnd &= 0x8000;
            break;
        }
    }
}

/*--------------------------------------
    DrawColors paints and frames the color rects for use as our pseudo-
    controls in the control color editor.  It should be called in the
    drawProc for this editor's windows.  We don't differentiate between
    320 & 640 modes, since in 320 mode we simply use the same values- on
    a double width window, just as the rest of the system does.

    Mark T. Collins    3/9/92  12:26PM
*/

void DrawColors ()
{
word            i, j, curType, vMode;
PrivDataPtr     mPtr;

    vMode = (GetMasterSCB() & 0x80) ? 0, 1; /* 0 = 640 */
    (Pointer) mPtr = deref((Handle) MasterCHndl);
    curType = mPtr->shortKind;
    GetPenPat(oldPenPat);
    GetPenSize(oldPenSize);
    SetPenSize(ourPen[vMode]);
    j = Slave[curType].numColors;
    for (i = 0; i < j; i++) {
        SetSolidPenPat(mPtr->MasterColor[Slave[curType].color[i]]);
        PaintRect(ColorRect[Slave[curType].cRect[i]);
        SetSolidPenPat(0);
        FrameRect(ColorRect[Slave[curType].cRect[i]);
    }
    SetPenSize(oldPenSize);
    SetPenPat(oldPenPat);
}

/*--------------------------------------
    CheckColorChange is called upon a MouseDown event in the Control Color
    editor.  It first determines if the hit was in one of the appropriate
    Color Boxes- if so, it dispatches to fSelectColor to allow the user to
    change color.  If not, it simply returns with nothing done.

    Mark T. Collins    3/9/92  12:57PM
*/

void CheckColorChange (pointPtr thePoint);
{
word            i, j, curType;
PrivDataPtr     mPtr;


    (Pointer) mPtr = deref((Handle) MasterCHndl);
    curType = mPtr->shortKind;
    j = Slave[curType].numColors;
    for (i = j; i >= 0; i--) {
        if PointInRect(thePoint, ColorRect[Slave[curType].cRect[i]) {
            p.pCount = 2;
            p.point = thePoint;
            p.color = mPtr->MasterColor[i];
            fSelectColor(&p);
            mPtr->MasterColor[Slave[curType].color[i]] = p.color;
            DrawColors();
            break;
        }
    }
}

void HandleSpecialButtons (word theID)  /* this should be the control ID hit */
{
long    newID;

    switch (theID) {
        case vertScrollBar:
        case horzScrollBar: {
            newID = CtlColorEdBackDoor(6);  /* this needs some fleshing out */
                                            /* after we BUILD our front and */
                                            /* back doors! The 6 stands for */
                                            /* our Short Kind (Scroll Bar */
            break;
        }
        case sizeBox: {
            newID = CtlColorEdBackDoor(6);
            break;
        }
    }
}
